// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPresets.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_barcode_label_presets_main',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_presets/main',

    cls: 'viison-common--window has--no-border',
    layout: 'fit',
    autoShow: true,
    width: 1200,
    height: '90%',
    border: false,

    mainController: null,

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.items = this.createLayout();

        this.callParent(arguments);
    },

    /**
     * Returns the main layout.
     *
     * @returns {Object[]}
     */
    createLayout: function () {
        return [{
            xtype: 'container',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            border: false,
            flex: 1,
            items: [
                {
                    width: '100%',
                    flex: 1,
                    layout: {
                        type: 'hbox',
                        align: 'stretch',
                    },
                    border: false,
                    items: [
                        {
                            xtype: 'viison_pickware_erp_barcode_label_presets_list',
                            store: this.subApp.getStore('Presets'),
                        },
                        {
                            xtype: 'viison_pickware_erp_barcode_label_presets_editor_context',
                            flex: 1,
                        },
                    ],
                },
            ],
        }];
    },

});
