// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.model.ArticleBarcodeLabel', {

    extend: 'Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.model.BarcodeLabel',
    fields: [
        { name: 'articleName', type: 'string' },
        { name: 'articleNumber', type: 'string' },
        { name: 'price', type: 'float' },
    ],
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl('/ViisonPickwareERPBarcodeLabelPrinting/getArticleBarcodeLabelList'),
            update: ViisonCommonApp.assembleBackendUrl('/ViisonPickwareERPBarcodeLabelPrinting/updateArticleBarcodeLabel'),
            destroy: ViisonCommonApp.assembleBackendUrl('/ViisonPickwareERPBarcodeLabelPrinting/deleteArticleBarcodeLabels'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
        writer: {
            type: 'json',
            root: 'data',
            allowSingle: false,
        },
    },
});
