// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.model.BinLocationBarcodeLabel', {

    extend: 'Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.model.BarcodeLabel',
    fields: [
        { name: 'binLocationId', type: 'int' },
        { name: 'binLocationCode', type: 'string' },
        { name: 'warehouseCode', type: 'string' },
        { name: 'warehouseName', type: 'string' },
    ],
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl('/ViisonPickwareERPBarcodeLabelPrinting/getBinLocationBarcodeLabelList'),
            update: ViisonCommonApp.assembleBackendUrl('/ViisonPickwareERPBarcodeLabelPrinting/updateBinLocationBarcodeLabel'),
            destroy: ViisonCommonApp.assembleBackendUrl('/ViisonPickwareERPBarcodeLabelPrinting/deleteBinLocationBarcodeLabels'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
        writer: {
            type: 'json',
            root: 'data',
            allowSingle: false,
        },
    },

});
