// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.ArticleLabels', {

    extend: 'Ext.form.Panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_printing/main',

    layout: 'fit',
    border: false,
    bodyStyle: {
        border: 'none',
    },
    customIdentifier: 'tabParent',
    listeners: {
        activate: function () {
            this.presetStore.clearFilter();
            this.presetStore.filter('type', 'article');
            this.presetStore.addListener('load', function () {
                var presetId = this.presetStore.findBy(function (record) {
                    return record.get('type') === 'article' && record.get('default') === true;
                }, this);

                if (presetId === -1) {
                    return;
                }

                this.down('viison_pickware_erp_barcode_label_printing_preset_print_settings').setPreset(
                    this.presetStore.getAt(presetId)
                );
            }, this);
        },
    },

    initComponent: function () {
        var customerGroupStore = Ext.create('Shopware.store.CustomerGroup', {
            storeId: undefined,
            listeners: {
                load: function (store) {
                    var ekGroup = store.findRecord('key', 'EK');
                    var combobox = Ext.ComponentQuery.query('[customIdentifier=tabParent] [name=customerGroup]')[0];

                    if (combobox && ekGroup) {
                        combobox.setValue(ekGroup.get('id'));
                    }
                },
            },
        });
        customerGroupStore.load();

        var shopStore = Ext.create('Shopware.store.ShopLanguage', {
            shopId: undefined,
            listeners: {
                load: function (store) {
                    var defaultStore = store.findRecord('default', true);
                    var comboboxes = Ext.ComponentQuery.query('[customIdentifier=tabParent] [name=shop]');

                    var combobox = null;
                    for (var i = 0; i < comboboxes.length; i += 1) {
                        // Make sure that the combobox on screen is used. For some reason, ExtJS keeps instances which
                        // are not displayed and used anymore around.
                        if (comboboxes[i].getEl()) {
                            combobox = comboboxes[i];

                            break;
                        }
                    }

                    if (combobox && defaultStore) {
                        combobox.setValue(defaultStore.get('id'));
                    }
                },
            },
        });
        shopStore.load();

        this.items = [
            {
                xtype: 'container',
                border: false,
                layout: {
                    type: 'hbox',
                    align: 'stretch',
                },
                height: '100%',
                items: [
                    {
                        xtype: 'container',
                        flex: 1,
                        border: false,
                        layout: 'fit',
                        items: [
                            {
                                xtype: 'viison_pickware_erp_barcode_label_printing_article_list',
                                store: this.labelStore,
                                dockedItems: [
                                    {
                                        xtype: 'toolbar',
                                        dock: 'top',
                                        ui: 'shopware-ui',
                                        cls: 'shopware-toolbar',
                                        style: {
                                            borderBottom: '1px solid #a4b5c0 !important',
                                        },
                                        padding: '10 10 10 10',
                                        items: [
                                            '->',
                                            {
                                                xtype: 'label',
                                                cls: 'is--viison-common--label',
                                                text: this.getViisonSnippet('form/article_search/label') + ':',
                                                margin: '0 10 0 0',
                                            },
                                            {
                                                xtype: 'articlesearchfield',
                                                cls: 'is--viison-common--article-live-search-field',
                                                name: 'details.articleNumber',
                                                hideLabel: true,
                                                store: Ext.create('Shopware.apps.Base.store.Variant', {}),
                                                width: 250,
                                                dropDownOffset: [0, 8],
                                                listeners: {
                                                    scope: this,
                                                    valueselect: function (editor, articleName, articleNumber, articleRecord) {
                                                        this.up('viison_pickware_erp_barcode_label_printing').fireEvent(
                                                            'addArticleBarcodeLabel',
                                                            this,
                                                            articleRecord
                                                        );
                                                        // Clear article search field
                                                        editor.hiddenField.setValue('');
                                                        editor.searchField.setValue('');
                                                    },
                                                },
                                                helpText: this.getViisonSnippet('form/article_search/tooltip'),
                                            },
                                        ],
                                    },
                                ],
                            },
                        ],
                    },
                    {
                        xtype: 'container',
                        width: 350,
                        border: false,
                        padding: 20,
                        style: {
                            backgroundColor: '#ECEDEF',
                        },
                        layout: {
                            type: 'vbox',
                            align: 'stretch',
                        },
                        items: [
                            {
                                xtype: 'viison_pickware_erp_barcode_label_printing_preset_print_settings',
                                presetStore: this.presetStore,
                                presetType: 'article',
                            },
                            {
                                xtype: 'tbspacer',
                                height: 15,
                            },
                            {
                                xtype: 'label',
                                cls: 'is--viison-common--label',
                                text: this.getViisonSnippet('base/customer_group', 'backend/customer/view/detail') + ':',
                                margin: '0 0 5 0',
                            },
                            {
                                xtype: 'combobox',
                                name: 'customerGroup',
                                hideLabel: true,
                                store: customerGroupStore,
                                displayField: 'name',
                                valueField: 'id',
                                queryMode: 'local',
                                allowBlank: false,
                                helpText: this.getViisonSnippet('form/customer_group/tooltip'),
                            },
                            {
                                xtype: 'tbspacer',
                                height: 15,
                            },
                            {
                                xtype: 'label',
                                cls: 'is--viison-common--label',
                                text: this.getViisonSnippet('base/shop', 'backend/customer/view/detail') + ':',
                                margin: '0 0 5 0',
                            },
                            {
                                xtype: 'combobox',
                                name: 'shop',
                                hideLabel: true,
                                store: shopStore,
                                displayField: 'name',
                                valueField: 'id',
                                queryMode: 'local',
                                allowBlank: false,
                                helpText: this.getViisonSnippet('form/shop/tooltip'),
                            },
                        ],
                    },
                ],
            },
        ];

        this.dockedItems = [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware-ui',
                cls: 'shopware-toolbar is--viison-common--button-panel is--primary',
                items: [
                    {
                        text: this.getViisonSnippet('form/buttons/delete_barcode_labels'),
                        cls: 'secondary',
                        action: 'deleteBarcodeLabels',
                    }, {
                        xtype: 'tbfill',
                    }, {
                        text: this.getViisonSnippet('toolbar/buttons/cancel'),
                        cls: 'secondary',
                        action: 'cancel',
                    },
                    {
                        text: this.getViisonSnippet('toolbar/buttons/print_barcode_labels'),
                        cls: 'primary',
                        action: 'showBarcodeLabels',
                    },
                ],
            },
        ];

        this.callParent(arguments);
    },

});
