// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.BinLocationLabels', {

    extend: 'Ext.form.Panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_printing/main',

    layout: 'fit',
    border: false,
    bodyStyle: {
        border: 'none',
    },
    customIdentifier: 'tabParent',
    listeners: {
        activate: function () {
            this.presetStore.clearFilter();
            var preset = this.presetStore.findRecord('type', 'bin');

            if (preset) {
                this.down('viison_pickware_erp_barcode_label_printing_preset_print_settings').setPreset(preset);
            }
        },
    },

    initComponent: function () {
        var customerGroupStore = Ext.create('Shopware.store.CustomerGroup', {
            storeId: undefined,
        });
        customerGroupStore.load();

        var shopStore = Ext.create('Shopware.store.Shop', {
            shopId: undefined,
        });
        shopStore.load();

        this.items = [
            {
                xtype: 'container',
                border: false,
                layout: {
                    type: 'hbox',
                    align: 'stretch',
                },
                height: '100%',
                items: [
                    {
                        xtype: 'container',
                        flex: 1,
                        border: false,
                        layout: 'fit',
                        items: [
                            {
                                xtype: 'viison_pickware_erp_barcode_label_printing_bin_location_list',
                                store: this.labelStore,
                                dockedItems: [
                                    {
                                        xtype: 'toolbar',
                                        dock: 'top',
                                        ui: 'shopware-ui',
                                        cls: 'shopware-toolbar',
                                        style: {
                                            borderBottom: '1px solid #a4b5c0 !important',
                                        },
                                        padding: '10 10 10 10',
                                        items: [
                                            '->',
                                            {
                                                xtype: 'label',
                                                cls: 'is--viison-common--label',
                                                text: this.getViisonSnippet('form/bin_location_search/label') + ':',
                                                margin: '0 10 0 0',
                                            },
                                            {
                                                xtype: 'viison_pickware_erp_barcode_label_printing-main-form-bin_location_search',
                                                name: 'binLocationSearch',
                                                cls: 'is--viison-common--hide-field-label is--viison-common--article-live-search-field',
                                                width: 250,
                                                dropDownOffset: [0, 8],
                                                listeners: {
                                                    scope: this,
                                                    valueselect: function (editor, binLocationId, binLocationCode, binLocation) {
                                                        this.up('viison_pickware_erp_barcode_label_printing').fireEvent(
                                                            'addBinLocationBarcodeLabel',
                                                            this,
                                                            binLocation
                                                        );
                                                        // Clear bin location search field
                                                        editor.hiddenField.setValue('');
                                                        editor.searchField.setValue('');
                                                    },
                                                },
                                            },
                                        ],
                                    },
                                ],
                            },
                        ],
                    },
                    {
                        xtype: 'container',
                        width: 350,
                        border: false,
                        padding: 20,
                        style: {
                            backgroundColor: '#ECEDEF',
                        },
                        layout: {
                            type: 'vbox',
                            align: 'stretch',
                        },
                        items: [
                            {
                                xtype: 'viison_pickware_erp_barcode_label_printing_preset_print_settings',
                                presetName: 6,
                                presetStore: this.presetStore,
                            },
                        ],
                    },
                ],
            },
        ];

        this.dockedItems = [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware-ui',
                cls: 'shopware-toolbar is--viison-common--button-panel is--primary',
                items: [
                    {
                        text: this.getViisonSnippet('form/buttons/delete_barcode_labels'),
                        cls: 'secondary',
                        action: 'deleteBarcodeLabels',
                    }, {
                        xtype: 'tbfill',
                    }, {
                        text: this.getViisonSnippet('toolbar/buttons/cancel'),
                        cls: 'secondary',
                        action: 'cancel',
                    },
                    {
                        text: this.getViisonSnippet('toolbar/buttons/print_barcode_labels'),
                        cls: 'primary',
                        action: 'showBarcodeLabels',
                    },
                ],
            },
        ];

        this.callParent(arguments);
    },

});
