// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.PresetPrintSettings', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_barcode_label_printing_preset_print_settings',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_printing/main',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },
    border: 0,
    items: [],

    /**
     * @override
     */
    initComponent: function () {
        var disabled = false;
        var presetValue;

        if (this.presetName) {
            presetValue = this.presetName;
            disabled = true;
        }

        this.items = [
            {
                xtype: 'label',
                cls: 'is--viison-common--label',
                text: this.getViisonSnippet('form/preset/label') + ':',
                margin: '0 0 5 0',
            },
            {
                xtype: 'combobox',
                hideLabel: true,
                name: 'preset',
                store: this.presetStore,
                queryMode: 'local',
                displayField: 'translatedName',
                valueField: 'id',
                disabled: disabled,
                value: presetValue,
                allowBlank: false,
                flex: 1,
                listeners: {
                    change: function (combobox, recordId) {
                        // Update the max values of the start position fields
                        var record = combobox.store.getById(recordId);

                        this.updateOffsetFields(combobox, record);
                    }.bind(this),
                },
            },
            {
                xtype: 'tbspacer',
                height: 15,
            },
            {
                xtype: 'label',
                cls: 'is--viison-common--label',
                text: this.getViisonSnippet('form/start_x/label') + ':',
                margin: '0 0 5 0',
            },
            {
                xtype: 'numberfield',
                cls: 'is--viison-common--numberfield',
                hideLabel: true,
                helpText: this.getViisonSnippet('form/start_x/help'),
                name: 'startX',
                value: 1,
                minValue: 1,
                maxValue: 16,
                allowDecimals: false,
                anchor: '100%',
                flex: 1,
            },
            {
                xtype: 'tbspacer',
                height: 15,
            },
            {
                xtype: 'label',
                cls: 'is--viison-common--label',
                text: this.getViisonSnippet('form/start_y/label') + ':',
                margin: '0 0 5 0',
            },
            {
                xtype: 'numberfield',
                cls: 'is--viison-common--numberfield',
                hideLabel: true,
                helpText: this.getViisonSnippet('form/start_y/help'),
                name: 'startY',
                value: 1,
                minValue: 1,
                maxValue: 16,
                allowDecimals: false,
                anchor: '100%',
                flex: 1,
            },
        ];

        this.callParent(arguments);
    },

    /**
     * Changes the preset of the preset combobox and adjusts all depending fields.
     *
     * @param {Object} preset
     */
    setPreset: function (preset) {
        var combobox = this.down('[name=preset]');

        if (!combobox) {
            return;
        }

        this.updateOffsetFields(combobox, preset);
        combobox.setValue(preset.get('id'));
    },

    /**
     * Sets the maximum value for the offset fields based on the paper layout chosen.
     *
     * @param {Object} combobox
     * @param {Object} record
     */
    updateOffsetFields: function (comboBox, record) {
        if (!record) {
            return;
        }

        var startX = comboBox.next('[name=startX]');
        var startY = comboBox.next('[name=startY]');

        if (record.get('columnAmount') > 1 && startX) {
            startX.setMaxValue(record.get('columnAmount'));
            startX.enable();
        } else {
            startX.disable();
        }

        if (record.get('columnAmount') > 1 && startY) {
            startY.setMaxValue(record.get('rowAmount'));
            startY.enable();
        } else {
            startY.disable();
        }
    },

});
