// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.Main', {

    extend: 'Enlight.app.Window',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_printing/main',

    alias: 'widget.viison_pickware_erp_barcode_label_printing',
    cls: 'viison-common--window has--no-border',
    layout: 'fit',
    autoShow: true,
    width: 1100,
    height: '80%',
    border: false,
    maximizable: false,
    minimizable: false,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.items = [
            this.createTabPanel(),
        ];

        this.callParent(arguments);
    },

    /**
     * @returns {Ext.tab.Panel}
     */
    createTabPanel: function () {
        var presetStore = Ext.create('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.store.ArticlePreset', {
            listeners: {
                load: function (store) {
                    var defaultPreset = store.findRecord('default', true);
                    if (!defaultPreset) {
                        defaultPreset = store.first();
                    }

                    var comboboxes = Ext.ComponentQuery.query('[customIdentifier=tabParent] [name=preset]');
                    var combobox = null;
                    for (var i = 0; i < comboboxes.length; i += 1) {
                        // Make sure that the combobox on screen is used and not a combobox of the other tabs.
                        if (comboboxes[i].getEl()) {
                            combobox = comboboxes[i];

                            break;
                        }
                    }

                    if (combobox && defaultPreset) {
                        combobox.setValue(defaultPreset.get('id'));
                    }
                },
            },
        });
        presetStore.load();

        return Ext.create('Ext.tab.Panel', {
            name: 'main-tab',
            items: this.getTabs(presetStore),
        });
    },

    /**
     * Creates the tabs for the different label types.
     *
     * @param {Ext.store} presetStore
     * @returns {Array<Object>}
     */
    getTabs: function (presetStore) {
        return [
            Ext.create('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.ArticleLabels', {
                title: this.getViisonSnippet('article_labels/title'),
                labelStore: this.articleLabelStore,
                presetStore: presetStore,
            }),
            Ext.create('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.BinLocationLabels', {
                title: this.getViisonSnippet('bin_locations/title'),
                labelStore: this.binLocationLabelStore,
                presetStore: presetStore,
            }),
        ];
    },

});
