// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.main.ArticleList', {

    extend: 'Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.main.List',
    alias: 'widget.viison_pickware_erp_barcode_label_printing_article_list',

    /**
     * @override
     */
    getCustomColumns: function () {
        return [{
            xtype: 'gridcolumn',
            dataIndex: 'articleName',
            header: this.getViisonSnippet('list/columns/article_name'),
            flex: 7,
            getSortParam: function () {
                return 'article.name';
            },
        }, {
            xtype: 'gridcolumn',
            dataIndex: 'articleNumber',
            header: this.getViisonSnippet('list/columns/order_number'),
            flex: 2,
            getSortParam: function () {
                return 'articleDetail.number';
            },
        }, {
            xtype: 'gridcolumn',
            dataIndex: 'price',
            header: this.getViisonSnippet('list/columns/price'),
            sortable: false,
            align: 'right',
            flex: 1,
            renderer: ViisonCurrencyFormatter.renderer,
        }];
    },

    /**
     * @override
     */
    initComponent: function () {
        this.callParent(arguments);

        var quantityColumn = this.columns.find(function (column) {
            return column.dataIndex === 'quantity';
        });
        if (quantityColumn) {
            quantityColumn.getSortParam = function () {
                return 'barcodeLabel.quantity';
            };
        }
    },

});
