// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.main.BinLocationList', {

    extend: 'Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.main.List',
    alias: 'widget.viison_pickware_erp_barcode_label_printing_bin_location_list',

    /**
     * @override
     */
    getCustomColumns: function () {
        return [{
            xtype: 'gridcolumn',
            dataIndex: 'binLocationCode',
            header: this.getViisonSnippet('bin_location_list/columns/bin_location_code'),
            flex: 1,
            getSortParam: function () {
                return 'binLocation.code';
            },
        }, {
            xtype: 'gridcolumn',
            dataIndex: 'warehouseName',
            header: this.getViisonSnippet('bin_location_list/columns/warehouse_name'),
            flex: 1,
            renderer: function (value, meta, record) {
                return value + ' (' + record.get('warehouseCode') + ')';
            },
            getSortParam: function () {
                return 'warehouse.name';
            },
        }];
    },

    /**
     * @override
     */
    initComponent: function () {
        this.callParent(arguments);

        var quantityColumn = this.columns.find(function (column) {
            return column.dataIndex === 'quantity';
        });
        if (quantityColumn) {
            quantityColumn.getSortParam = function () {
                return 'barcodeLabel.quantity';
            };
        }
    },

});
