// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.main.form.BinLocationSearch', {

    extend: 'Shopware.form.field.ArticleSearch',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_printing/main',

    alias: 'widget.viison_pickware_erp_barcode_label_printing-main-form-bin_location_search',
    returnValue: 'code',
    hiddenReturnValue: 'id',
    searchFieldName: 'live-bin-location-search',
    hiddenFieldName: 'hidden-bin-location-search',
    store: Ext.create('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.store.BinLocation', {}),
    searchScope: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.callParent(arguments);

        this.fieldLabel = this.getViisonSnippet('form/bin_location_search/label');

        // Modify the dropdown store to make sure the warehouse information of each bin location is available
        this.dropDownStore.getProxy().extraParams = this.dropDownStore.getProxy().extraParams || {};
        this.dropDownStore.getProxy().extraParams.includeWarehouseData = true;
    },

    /**
     * @Override
     */
    createDropDownMenuTpl: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<div class="header">',
                '<div class="header-inner">',
                    '<div class="arrow">&nbsp;</div>',
                    '<span class="title">' + this.getViisonSnippet('form/bin_location_search/drop_down_title') + '</span>',
                '</div>',
            '</div>',
            '<div class="content">',
                '{literal}<tpl for=".">',
                    '<div class="item">',
                        '<strong class="name">{code}</strong>',
                        '<span class="ordernumber">{id:this.getWarehouseTitle}</span>',
                    '</div>',
                '</tpl>{/literal}',
            '</div>',
            {
                getWarehouseTitle: function (id) {
                    // Find the warehouse of the record that is being rendered
                    var index = this.dropDownStore.findExact('id', id);
                    var record = this.dropDownStore.getAt(index);
                    var warehouse = record.getWarehouse();

                    return warehouse.get('name') + ' (' + warehouse.get('code') + ')';
                }.bind(this),
            }
        );
        /* eslint-enable indent */
    },

});
