// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPrinting.view.main.List', {

    extend: 'Ext.grid.Panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_printing/main',

    alias: 'widget.viison_pickware_erp_barcode_label_printing-main-list',
    cls: 'viison-common--grid has--vertical-lines',
    split: true,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },
    border: false,
    style: {
        border: 'none',
        borderRight: '1px solid #a4b5c0 !important',
    },

    /**
     * @Override
     */
    initComponent: function () {
        // Init the grid selection model
        this.selModel = Ext.create('Ext.selection.CheckboxModel', {
            checkOnly: true,
            listeners: {
                selectionchange: function (model, selection) {
                    // Get the 'print labels' button and change its title
                    var labelListTab = this.up('[customIdentifier=tabParent]');
                    var printButton = labelListTab.down('[action=showBarcodeLabels]');
                    var newTitle = (selection.length === 0) ? this.getViisonSnippet('toolbar/buttons/print_barcode_labels') : this.getViisonSnippet('toolbar/buttons/print_selected_barcode_labels');
                    printButton.setText(newTitle);

                    // Get the 'delete labels' button and change its title
                    var deleteButton = labelListTab.down('[action=deleteBarcodeLabels]');
                    newTitle = (selection.length === 0) ? this.getViisonSnippet('form/buttons/delete_barcode_labels') : this.getViisonSnippet('form/buttons/delete_selected_barcode_labels');
                    deleteButton.setText(newTitle);
                },
                scope: this,
            },
        });

        this.columns = [].concat(this.getCustomColumns(), [{
            xtype: 'numbercolumn',
            header: this.getViisonSnippet('list/columns/quantity'),
            dataIndex: 'quantity',
            format: '0',
            align: 'right',
            width: 75,
            editor: {
                xtype: 'numberfield',
                allowBlank: false,
                minValue: 1,
                allowDecimals: false,
                padding: '0 5 0 0',
            },
        }, {
            xtype: 'actioncolumn',
            width: 30,
            align: 'center',
            items: [
                {
                    iconCls: 'sprite-minus-circle-frame',
                    action: 'deleteBarcodeLabel',
                    tooltip: this.getViisonSnippet('list/columns/delete/tooltip'),
                    scope: this,
                    handler: function (view, rowIndex, colIndex, item, event, record) {
                        this.fireEvent('deleteBarcodeLabel', this.up('viison_pickware_erp_barcode_label_printing [customIdentifier=tabParent]'), record);
                    },
                },
            ],
        }]);

        this.dockedItems = this.dockedItems || [];
        this.dockedItems.push({
            store: this.store,
            xtype: 'viison_common_pagination_toolbar-toolbar',
        });

        this.plugins = [
            Ext.create('Ext.grid.plugin.RowEditing', {
                clicksToEdit: 2,
                autoCancel: true,
                listeners: {
                    scope: this,
                    edit: function (editor, event) {
                        this.fireEvent('saveBarcodeLabel', event.record);
                    },
                },
            }),
        ];

        this.callParent(arguments);
    },

    /**
     * Override in derived classes to add further columns.
     *
     * @returns {array}
     */
    getCustomColumns: function () {
        return [];
    },

    /**
     * Returns the filter property name to use when rendering only selected barcode labels.
     *
     * @returns {string}
     */
    getFilterPropertyName: function () {
        return 'barcodeLabel.id';
    },
});
