// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.BinLocationCreation.Panel', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_bin_location_editor-bin_location_creation-panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    bodyPadding: 10,
    defaults: {
        labelWidth: 120,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.form.field.Field[]
     */
    createItems: function () {
        return [
            {
                xtype: 'textfield',
                name: 'code',
                fieldLabel: this.getViisonSnippet('bin_location_creation/panel/form/code/label'),
                allowBlank: false,
            },
        ];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware-ui',
                items: [
                    '->',
                    {
                        xtype: 'button',
                        text: this.getViisonSnippet('bin_location_creation/panel/toolbar/cancel'),
                        cls: 'secondary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('cancel', this);
                        },
                    }, {
                        xtype: 'button',
                        text: this.getViisonSnippet('bin_location_creation/panel/toolbar/save'),
                        cls: 'primary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('save', this);
                        },
                    },
                ],
            },
        ];
    },

});
