// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.BinLocationSelection', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_bin_location_editor-bin_location_selection',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    layout: 'vbox',
    modal: true,
    width: 450,
    height: 700,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('bin_location_selection/window/title');

        // Create a new store containing all current bin location mappings
        this.binLocationMappingStore = Ext.create('Shopware.apps.ViisonPickwareERPArticleBinLocationList.store.BinLocationMappings', {
            remoteSort: false,
            remoteFilter: false,
        });
        this.binLocationMappingStore.loadData(this.binLocationMappings);

        // Create a new bin location store for the window
        this.binLocationStore = Ext.create('Shopware.apps.ViisonPickwareERPWarehouseManagement.store.BinLocation', {
            pageSize: 20,
            filters: [
                { property: 'binLocation.warehouseId', value: this.warehouse.id },
            ],
        });
        this.binLocationStore.load();

        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();
        this.title = this.warehouse.name + ' (' + this.warehouse.code + ') – ' + this.title;

        this.callParent(arguments);
    },

    /**
     * @return Ext.Component[]
     */
    createItems: function () {
        return [
            {
                xtype: 'viison_pickware_erp_bin_location_editor-bin_location_selection-bin_location_mapping_list',
                store: this.binLocationMappingStore,
                width: '100%',
                flex: 1,
                collapsible: true,
                collapseDirection: 'top',
            }, {
                xtype: 'viison_pickware_erp_bin_location_editor-bin_location_selection-bin_location_list',
                store: this.binLocationStore,
                width: '100%',
                flex: 2,
                collapsible: true,
                collapseDirection: 'top',
            },
        ];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware-ui',
                items: [
                    '->',
                    {
                        xtype: 'button',
                        text: this.getViisonSnippet('bin_location_selection/window/toolbar/cancel'),
                        cls: 'secondary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('cancel', this);
                        },
                    }, {
                        xtype: 'button',
                        text: this.getViisonSnippet('bin_location_selection/window/toolbar/save'),
                        cls: 'primary',
                        action: 'save',
                        disabled: true,
                        scope: this,
                        handler: function () {
                            this.fireEvent('save', this);
                        },
                    },
                ],
            },
        ];
    },

});
