// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.BinLocationSelection.BinLocationList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_bin_location_editor-bin_location_selection-bin_location_list',
    cls: 'viison-pickware-erp-bin-location-editor--bin-location-selection--bin-location-list',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    split: true,
    border: true,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('bin_location_selection/bin_location_list/title');
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();
        this.selModel = Ext.create('Ext.selection.CheckboxModel', {
            mode: 'SINGLE',
            showHeaderCheckbox: false,
            listeners: {
                scope: this,
                selectionchange: function (model, selection) {
                    this.fireEvent('binLocationSelectionChanged', this, selection);
                },
            },
        });

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        return [
            {
                dataIndex: 'code',
                header: this.getViisonSnippet('bin_location/code'),
                flex: 1,
            },
        ];
    },

    /**
     * Creates a search toolbar located at the top as well as a paging toolbar located at the bottom.
     *
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'top',
                ui: 'shopware-ui',
                items: [
                    {
                        xtype: 'button',
                        text: this.getViisonSnippet('bin_location_selection/window/toolbar/add_bin_location'),
                        iconCls: 'sprite-plus-circle-frame',
                        scope: this,
                        handler: function () {
                            this.fireEvent('createBinLocation', this);
                        },
                    },
                    '->',
                    {
                        xtype: 'textfield',
                        name: 'searchfield',
                        cls: 'searchfield',
                        width: 170,
                        enableKeyEvents: true,
                        emptyText: this.getViisonSnippet('bin_location_selection/bin_location_list/toolbar/search_field/placeholder'),
                        listeners: {
                            buffer: 500,
                            scope: this,
                            change: function (field) {
                                this.store.getProxy().extraParams.query = field.value;
                                this.store.loadPage(1);
                            },
                        },
                    },
                ],
            }, {
                xtype: 'viison_common_pagination_toolbar-toolbar',
                store: this.store,
                displayInfo: false,
            },
        ];
    },

});
