// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.BinLocationSelection.BinLocationMappingList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_bin_location_editor-bin_location_selection-bin_location_mapping_list',
    cls: 'viison-common--grid viison-pickware-erp-bin-location-editor--bin-location-selection--bin-location-mapping-list',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    split: true,
    border: true,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('bin_location_selection/bin_location_mapping_list/title');
        this.columns = this.createColumns();
        this.selModel = Ext.create('Ext.selection.CheckboxModel', {
            mode: 'SINGLE',
            showHeaderCheckbox: false,
            listeners: {
                scope: this,
                selectionchange: function (model, selection) {
                    this.fireEvent('binLocationMappingSelectionChanged', this, selection);
                },
            },
        });

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        return [
            {
                dataIndex: 'isMappingToNullBinLocation',
                header: this.getViisonSnippet('bin_location/code'),
                sortable: false,
                flex: 2,
                renderer: function (value, metaData, record) {
                    var nullBinLocation = this.getViisonSnippet('null_bin_location');
                    var renderValue = (value) ? '<i>' + nullBinLocation + '</i>' : record.get('binLocation').code;
                    if (record.get('defaultMapping')) {
                        renderValue += '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="sprite-star" style="margin-bottom: -4px; margin-left: 5px; padding-left: 16px;"data-qtip="' + this.getViisonSnippet('default_bin_location_mapping') + '">';
                    }

                    return renderValue;
                },
            }, {
                dataIndex: 'stock',
                header: this.getViisonSnippet('bin_location_selection/bin_location_mapping_list/column/stock'),
                sortable: false,
                flex: 1,
                align: 'right',
            },
        ];
    },

});
