// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_bin_location_editor-main',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    layout: 'border',
    modal: true,
    width: 480,
    height: 350,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.warehouse.name + ' (' + this.warehouse.code + ') – ' + this.getViisonSnippet('main/window/title');
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Object[]
     */
    createItems: function () {
        return [
            {
                xtype: 'tabpanel',
                region: 'center',
                articleDetailId: this.articleDetailId,
                warehouse: this.warehouse,
                binLocationMappingStore: this.binLocationMappingStore,
                items: this.createTabs(),
            },
        ];
    },

    /**
     * @return Object[]
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware',
                cls: 'is--viison-common--button-panel',
                items: [
                    '->',
                    {
                        text: this.getViisonSnippet('main/toolbar/button/cancel'),
                        cls: 'secondary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('cancel', this);
                        },
                    }, {
                        text: this.getViisonSnippet('main/toolbar/button/save'),
                        cls: 'primary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('save', this);
                        },
                    },
                ],
            },
        ];
    },

    /**
     * @return Object[]
     */
    createTabs: function () {
        // Determine the bin location mappings of the configured warehouse
        var warehouseBinLocationMappings;
        Ext.each(this.binLocationMappingStore.getGroups(), function (group) {
            if (group.name === this.warehouse.id) {
                warehouseBinLocationMappings = group.children;

                return false;
            }

            return undefined;
        }, this);

        // Pre-select the edited bin location mapping or the first one in the list, if it's not the default mapping
        var binLocationMapping = this.selectedBinLocationMapping || warehouseBinLocationMappings[0];
        var selectedBinLocation = Ext.create('Shopware.apps.ViisonPickwareERPWarehouseManagement.model.BinLocation', {
            id: binLocationMapping.get('binLocation').id,
            warehouseId: binLocationMapping.get('binLocation').warehouseId,
            code: binLocationMapping.get('binLocation').code,
            warehouse: binLocationMapping.get('warehouse'),
        });

        return [
            {
                xtype: 'viison_pickware_erp_bin_location_editor-main-incoming',
                articleDetailId: this.articleDetailId,
                defaultPurchasePrice: this.defaultPurchasePrice,
                warehouse: this.warehouse,
                selectedBinLocation: selectedBinLocation,
                commentStore: this.commentStore,
            }, {
                xtype: 'viison_pickware_erp_bin_location_editor-main-outgoing',
                articleDetailId: this.articleDetailId,
                warehouse: this.warehouse,
                warehouseBinLocationMappings: warehouseBinLocationMappings,
                selectedBinLocation: selectedBinLocation,
                commentStore: this.commentStore,
            }, {
                xtype: 'viison_pickware_erp_bin_location_editor-main-relocation',
                articleDetailId: this.articleDetailId,
                warehouse: this.warehouse,
                binLocationMappingStore: this.binLocationMappingStore,
                warehouseBinLocationMappings: warehouseBinLocationMappings,
                selectedBinLocation: selectedBinLocation,
                commentStore: this.commentStore,
            }, {
                xtype: 'viison_pickware_erp_bin_location_editor-main-warehouse_stock_limits',
                warehouse: this.warehouse,
            },
        ];
    },

});
