// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.main.Incoming', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_bin_location_editor-main-incoming',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    itemId: 'incoming',
    layout: 'anchor',
    border: 0,
    bodyPadding: 20,
    defaults: {
        flex: 1,
        labelWidth: 150,
        anchor: '100%',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('main/incoming/title');
        this.items = [
            {
                xtype: 'numberfield',
                name: 'incomingStock',
                fieldLabel: this.getViisonSnippet('main/incoming/field/incoming_stock/label'),
                value: 0,
                minValue: 1,
                allowBlank: false,
                listeners: {
                    scope: this,
                    change: function () {
                        this.getForm().isValid();
                    },
                },
            }, {
                xtype: 'numberfield',
                name: 'purchasePrice',
                fieldLabel: ViisonPickwarePurchasePriceHelper.purchasePriceLabel(),
                value: this.defaultPurchasePrice,
                allowBlank: false,
                minValue: 0,
                listeners: {
                    scope: this,
                    change: function () {
                        this.getForm().isValid();
                    },
                },
            }, {
                xtype: 'viison_pickware_erp_bin_location_editor-main-bin_location_field',
                name: 'binLocation',
                fieldLabel: this.getViisonSnippet('main/incoming/field/bin_location/label'),
                value: this.selectedBinLocation,
                warehouse: this.warehouse,
                listeners: {
                    scope: this,
                    change: function () {
                        this.getForm().isValid();
                    },
                },
            }, {
                xtype: 'combo',
                name: 'comment',
                fieldLabel: this.getViisonSnippet('main/incoming/field/comment/label'),
                queryMode: 'local',
                store: this.commentStore,
                displayField: 'value',
                valueField: 'value',
                editable: true,
            },
        ];

        this.callParent(arguments);

        this.getForm().isValid();
    },

});
