// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.main.Outgoing', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_bin_location_editor-main-outgoing',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    itemId: 'outgoing',
    layout: 'anchor',
    border: 0,
    bodyPadding: 20,
    defaults: {
        flex: 1,
        labelWidth: 150,
        anchor: '100%',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('main/outgoing/title');
        this.items = [
            {
                xtype: 'numberfield',
                name: 'outgoingStock',
                fieldLabel: this.getViisonSnippet('main/outgoing/field/outgoing_stock/label'),
                value: 0,
                minValue: 1,
                allowBlank: false,
                listeners: {
                    scope: this,
                    change: function () {
                        this.getForm().isValid();
                    },
                },
                validator: function (value) {
                    // Validate the entered value agains the current stock on the selected bin location
                    var invalidText = this.getForm().findField('outgoingStock').invalidText;
                    var maxValue = Number.MAX_VALUE;
                    var selectedBinLocation = this.getForm().findField('binLocation').getSelectedRecord();
                    if (selectedBinLocation) {
                        Ext.each(this.warehouseBinLocationMappings, function (mapping) {
                            if (mapping.get('binLocationId') === selectedBinLocation.get('id')) {
                                maxValue = mapping.get('stock');
                                var binLocationCode = mapping.get('isMappingToNullBinLocation') ? this.getViisonSnippet('null_bin_location') : mapping.get('binLocation').code;

                                invalidText = Ext.String.format(
                                    this.getViisonSnippet(
                                        'main/outgoing/field/outgoing_stock/validation/value_exceeds_current_stock'
                                    ),
                                    binLocationCode,
                                    maxValue
                                );

                                return false;
                            }

                            return undefined;
                        }, this);
                    }

                    return (value <= maxValue) || invalidText;
                }.bind(this),
            }, {
                xtype: 'viison_pickware_erp_warehouse_management-bin_location_combo_box',
                name: 'binLocation',
                fieldLabel: this.getViisonSnippet('main/outgoing/field/bin_location/label'),
                emptyText: '',
                initialValue: this.selectedBinLocation.get('id'),
                warehouseId: this.warehouse.id,
                articleDetailId: this.articleDetailId,
                listeners: {
                    scope: this,
                    binLocationChanged: function () {
                        this.getForm().isValid();
                    },
                },
            }, {
                xtype: 'combo',
                name: 'comment',
                fieldLabel: this.getViisonSnippet('main/outgoing/field/comment/label'),
                queryMode: 'local',
                store: this.commentStore,
                displayField: 'value',
                valueField: 'value',
                editable: true,
            },
        ];

        this.callParent(arguments);

        this.getForm().isValid();
    },

});
