// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.main.Relocation', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_bin_location_editor-main-relocation',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    itemId: 'relocation',
    layout: 'anchor',
    border: 0,
    bodyPadding: 20,
    defaults: {
        flex: 1,
        labelWidth: 150,
        anchor: '100%',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('main/relocation/title');
        this.items = [
            {
                xtype: 'numberfield',
                name: 'relocatedStock',
                fieldLabel: this.getViisonSnippet('main/relocation/field/relocated_stock/label'),
                value: 0,
                minValue: 1,
                allowBlank: false,
                listeners: {
                    scope: this,
                    change: function () {
                        this.getForm().isValid();
                    },
                },
                validator: function (value) {
                    // Validate the entered value agains the current stock on the selected source bin location
                    var invalidText = this.getForm().findField('relocatedStock').invalidText;
                    var maxValue = Number.MAX_VALUE;
                    var selectedSourceBinLocation = this.getForm().findField('sourceBinLocation').getSelectedRecord();
                    if (selectedSourceBinLocation) {
                        Ext.each(this.warehouseBinLocationMappings, function (mapping) {
                            if (mapping.get('binLocationId') === selectedSourceBinLocation.get('id')) {
                                maxValue = mapping.get('stock');
                                var binLocationCode = mapping.get('isMappingToNullBinLocation') ? this.getViisonSnippet('null_bin_location') : mapping.get('binLocation').code;

                                invalidText = Ext.String.format(
                                    this.getViisonSnippet(
                                        'main/relocation/field/relocated_stock/validation/value_exceeds_current_stock'
                                    ),
                                    binLocationCode,
                                    maxValue
                                );

                                return false;
                            }

                            return undefined;
                        }, this);
                    }

                    return (value <= maxValue) || invalidText;
                }.bind(this),
            }, {
                xtype: 'viison_pickware_erp_warehouse_management-bin_location_combo_box',
                name: 'sourceBinLocation',
                fieldLabel: this.getViisonSnippet('main/relocation/field/source_bin_location/label'),
                emptyText: '',
                initialValue: this.selectedBinLocation.get('id'),
                warehouseId: this.warehouse.id,
                articleDetailId: this.articleDetailId,
                listeners: {
                    scope: this,
                    binLocationChanged: function () {
                        this.getForm().isValid();
                    },
                },
            }, {
                xtype: 'viison_pickware_erp_warehouse_management-warehouse_combo_box',
                name: 'destinationWarehouse',
                fieldLabel: this.getViisonSnippet('main/relocation/field/destination_warehouse/label'),
                initialValue: this.warehouse.id,
                listeners: {
                    scope: this,
                    warehouseChanged: function (warehouse) {
                        // Update the selected destination bin location using the first bin location mapping of the
                        // selected warehouse
                        var binLocationMappings;
                        Ext.each(this.binLocationMappingStore.getGroups(), function (group) {
                            if (group.name === warehouse.get('id')) {
                                binLocationMappings = group.children;

                                return false;
                            }

                            return undefined;
                        }, this);
                        var destinationBinLocation = Ext.create('Shopware.apps.ViisonPickwareERPWarehouseManagement.model.BinLocation', {
                            id: binLocationMappings[0].get('binLocation').id,
                            warehouseId: binLocationMappings[0].get('binLocation').warehouseId,
                            code: binLocationMappings[0].get('binLocation').code,
                            warehouse: binLocationMappings[0].get('warehouse'),
                        });
                        var destinationBinLocationField = this.getForm().findField('destinationBinLocation');
                        destinationBinLocationField.warehouse = warehouse.getData();
                        destinationBinLocationField.setValue(destinationBinLocation);

                        this.getForm().isValid();
                    },
                },
            }, {
                xtype: 'viison_pickware_erp_bin_location_editor-main-bin_location_field',
                name: 'destinationBinLocation',
                fieldLabel: this.getViisonSnippet('main/relocation/field/destination_bin_location/label'),
                warehouse: this.warehouse,
                listeners: {
                    scope: this,
                    change: function () {
                        this.getForm().isValid();
                    },
                },
                validator: function () {
                    // Validate that the selection destination bin location differs from the selected source
                    // bin location
                    var sourceBinLocation = this.getForm().findField('sourceBinLocation').getSelectedRecord();
                    if (!sourceBinLocation) {
                        return true;
                    }
                    var destinationBinLocation = this.getForm().findField('destinationBinLocation').selectedBinLocation;
                    var destinationBinLocationId = (destinationBinLocation) ? destinationBinLocation.get('id') : null;
                    var valid = (destinationBinLocationId === null && !sourceBinLocation.get('isNullBinLocation'))
                                || (destinationBinLocationId !== null && sourceBinLocation.get('id') !== destinationBinLocationId);

                    return valid || this.getViisonSnippet('main/relocation/field/destination_bin_location/validation/bin_locations_must_differ');
                }.bind(this),
            }, {
                xtype: 'combo',
                name: 'comment',
                fieldLabel: this.getViisonSnippet('main/relocation/field/comment/label'),
                queryMode: 'local',
                store: this.commentStore,
                displayField: 'value',
                valueField: 'value',
                editable: true,
            },
        ];

        this.callParent(arguments);

        this.getForm().isValid();
    },

});
