// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBinLocationEditor.view.main.WarehouseStockLimits', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_bin_location_editor-main-warehouse_stock_limits',
    cls: 'viison_pickware_erp_bin_location_editor-main-warehouse_stock_limits',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_bin_location_editor/main',

    itemId: 'warehouse_stock_limits',
    layout: 'anchor',
    border: 0,
    bodyPadding: 20,
    defaults: {
        flex: 1,
        labelWidth: 150,
        anchor: '100%',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('main/warehouse_stock_limits/title');
        this.items = [
            {
                xtype: 'container',
                cls: 'is--infotext',
                html: this.getViisonSnippet('main/warehouse_stock_limits/infotext'),
            }, {
                xtype: 'numberfield',
                name: 'minimumStock',
                itemId: 'minimumStockField',
                fieldLabel: this.getViisonSnippet('main/warehouse_stock_limits/minimum_stock/label'),
                value: this.warehouse.articleDetailConfigurations.minimumStock,
                minValue: 0,
                allowBlank: false,
                validator: function (value) {
                    var tab = this.up('viison_pickware_erp_bin_location_editor-main-warehouse_stock_limits');
                    var targetStock = parseInt(tab.down('#targetStockField').value, 10);
                    if (value <= targetStock) {
                        return true;
                    }

                    return tab.getViisonSnippet('main/warehouse_stock_limits/validation_error/message');
                },
            }, {
                xtype: 'numberfield',
                name: 'targetStock',
                itemId: 'targetStockField',
                fieldLabel: this.getViisonSnippet('main/warehouse_stock_limits/target_stock/label'),
                value: this.warehouse.articleDetailConfigurations.targetStock,
                minValue: 0,
                allowBlank: false,
                validator: function (value) {
                    var tab = this.up('viison_pickware_erp_bin_location_editor-main-warehouse_stock_limits');
                    var minimumStock = parseInt(tab.down('#minimumStockField').value, 10);
                    if (value >= minimumStock) {
                        return true;
                    }

                    return tab.getViisonSnippet('main/warehouse_stock_limits/validation_error/message');
                },
            },
        ];

        this.callParent(arguments);
    },

});
