// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCancellation.mixin.DataRetrieval', {

    /**
     * @returns {Shopware.apps.ViisonPickwareERPCancellation.model.Cancellation}
     */
    getCancellationRecord: function () {
        return this.subApp.getController('Editor').getCancellationRecord();
    },

    /**
     * @param {number} itemGroupId
     * @returns {Shopware.apps.ViisonPickwareERPCancellation.model.ItemGroup}
     */
    getItemGroupById: function (itemGroupId) {
        return this.subApp.getController('Editor').getItemGroupById(itemGroupId);
    },

    /**
     * @returns {Shopware.apps.ViisonPickwareERPCancellation.store.Tax}
     */
    getTaxesStore: function () {
        return this.subApp.getStore('Tax');
    },

});
