// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCancellation.model.Item', {

    extend: 'Ext.data.Model',

    fields: [
        { name: 'id', type: 'int' },
        { name: 'orderDetailId', type: 'int', useNull: true, default: null },
        { name: 'returnShipmentItemId', type: 'int' },
        { name: 'isPseudoItem', type: 'boolean', default: false },
        { name: 'isDeletable', type: 'boolean', default: false },
        { name: 'articleNumber', type: 'string' },
        { name: 'articleName', type: 'string' },
        { name: 'quantity', type: 'int' },
        { name: 'cancelQuantity', type: 'int' },
        { name: 'refundQuantity', type: 'int' },
        { name: 'taxId', type: 'int', useNull: true },
        { name: 'taxRate', type: 'float', default: 0 },
        { name: 'price', type: 'float', useNull: true },
        {
            name: 'totalPrice',
            type: 'float',
            convert: function (value, record) {
                if (record.get('isPseudoItem')) {
                    return record.get('price') * record.get('quantity');
                }

                return record.get('price') * record.get('refundQuantity');
            },
        },
    ],

    /**
     * @override
     */
    set: function (field) {
        this.callParent(arguments);

        if (!this.get('isPseudoItem') && field === 'cancelQuantity') {
            this.set('refundQuantity', this.get('cancelQuantity'));
        }

        if (!this.get('isPseudoItem') && field === 'refundQuantity') {
            this.set('totalPrice', this.get('price') * this.get('refundQuantity'));
        }

        if (this.get('isPseudoItem')
            && field === 'refundQuantity'
            && this.get('refundQuantity') !== this.get('quantity')
        ) {
            // Keep quantity and refund quantity of pseudo items in sync
            this.set('quantity', this.get('refundQuantity'));
        }

        if (this.get('isPseudoItem')
            && field === 'quantity'
            && this.get('quantity') !== this.get('refundQuantity')
        ) {
            // Keep quantity and refund quantity of pseudo items in sync
            this.set('refundQuantity', this.get('quantity'));
        }

        if (this.get('isPseudoItem') && (field === 'quantity' || field === 'price')) {
            this.set('totalPrice', this.get('price') * this.get('quantity'));
        }
    },

});
