// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCancellation.model.ItemGroup', {

    extend: 'Ext.data.Model',

    fields: [
        { name: 'id', type: 'int' },
        { name: 'type', type: 'string' },
        { name: 'returnShipmentId', type: 'int' },
        { name: 'returnShipmentNumber', type: 'string' },
        { name: 'cancelItemGroup', type: 'boolean' },
    ],

    associations: [
        {
            type: 'hasMany',
            model: 'Shopware.apps.ViisonPickwareERPCancellation.model.Item',
            name: 'getItems',
            associationKey: 'items',
        },
    ],

    /**
     * @returns {boolean}
     */
    isTypeReturnShipment: function () {
        return this.get('type') === 'RETURN_SHIPMENT';
    },

    /**
     * @returns {boolean}
     */
    isTypePseudo: function () {
        return this.get('type') === 'PSEUDO';
    },

    /**
     * @returns {boolean}
     */
    isDisabled: function () {
        return this.isTypeReturnShipment() ? !this.get('cancelItemGroup') : false;
    },

    /**
     * @returns {number}
     */
    getTotalAmount: function () {
        var totalAmount = 0.0;

        if (this.get('cancelItemGroup')) {
            this.getItems().each(function (item) {
                totalAmount += item.get('totalPrice');
            }, this);
        }

        return totalAmount;
    },

    /**
     * @returns {boolean}
     */
    containsItemsToBeCancelled: function () {
        var containsItemsToBeCancelled = false;

        this.getItems().each(function (item) {
            if (item.get('cancelQuantity') > 0) {
                containsItemsToBeCancelled = true;
            }
        }, this);

        return containsItemsToBeCancelled;
    },

});
