// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCancellation.view.Editor', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_cancellation-editor',
    cls: 'viison_pickware_erp_cancellation-editor',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
        'Shopware.apps.ViisonPickwareERPCancellation.mixin.DataRetrieval',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_cancellation/main',

    border: false,
    bodyStyle: {
        border: 'none !important',
    },

    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();
        this.getCancellationRecord().on(
            'totalAmountChanged',
            function (totalAmount) {
                if (totalAmount !== 0.0 || this.getCancellationRecord().containsItemsToBeCancelled()) {
                    this.down('#performCancellationButton').setDisabled(false);
                } else {
                    this.down('#performCancellationButton').setDisabled(true);
                }
                if (totalAmount !== 0.0 && this.getCancellationRecord().getDocumentData().get('createDocument')) {
                    this.down('#previewDocumentButton').setDisabled(false);
                } else {
                    this.down('#previewDocumentButton').setDisabled(true);
                }
            },
            this
        );
        this.getCancellationRecord().on(
            'createDocumentChanged',
            function (createDocument, cancellationRecord) {
                if (createDocument && cancellationRecord.get('totalAmount') !== 0.0) {
                    this.down('#previewDocumentButton').setDisabled(false);
                } else {
                    this.down('#previewDocumentButton').setDisabled(true);
                }
            },
            this
        );

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            this.subApp.getView('editor.DocumentSidebar').create(),
            {
                xtype: 'container',
                layout: {
                    type: 'vbox',
                    align: 'stretch',
                },
                flex: 1,
                items: [
                    {
                        xtype: 'viison_pickware_erp_cancellation-editor-header',
                    },
                    {
                        xtype: 'container',
                        cls: 'viison_pickware_erp_cancellation-editor-items',
                        padding: '0 0 40 0',
                        flex: 1,
                        autoScroll: true,
                        items: this.createItemListContainers(),
                    },
                    this.subApp.getView('editor.Footer').create(),
                ],
            },
        ];
    },

    /**
     * @returns {Shopware.apps.ViisonPickwareERPCancellation.view.editor.items.ItemListContainer[]}
     */
    createItemListContainers: function () {
        var itemListContainers = [];

        this.getCancellationRecord().getItemGroups().each(function (itemGroupRecord) {
            itemListContainers.push(
                this.subApp.getView('editor.items.ItemListContainer').create({
                    itemGroupId: itemGroupRecord.get('id'),
                })
            );
        }, this);

        return itemListContainers;
    },

    /**
     * @returns {object[]}
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware',
                cls: 'is--viison-common--button-panel',
                items: [
                    '->',
                    {
                        text: this.getViisonSnippet('editor/button/cancel/text'),
                        cls: 'secondary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('closeWindow', this);
                        },
                    }, {
                        text: this.getViisonSnippet('editor/button/preview_document/text'),
                        itemId: 'previewDocumentButton',
                        disabled: this.getCancellationRecord().get('totalAmount') === 0.0,
                        cls: 'primary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('previewDocument', this);
                        },
                    }, {
                        text: this.getViisonSnippet('editor/button/perform_cancellation/text'),
                        itemId: 'performCancellationButton',
                        disabled: this.getCancellationRecord().get('totalAmount') === 0.0,
                        cls: 'primary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('performCancellation', this);
                        },
                    },
                ],
            },
        ];
    },

});
