// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCancellation.view.editor.DocumentSidebar', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_cancellation-editor-document_sidebar',
    cls: 'viison-common--sidebar has--header-size-large has--no-border is--left-sidebar is--secondary',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
        'Shopware.apps.ViisonPickwareERPCancellation.mixin.DataRetrieval',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_cancellation/main',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    width: 320,

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('document_sidebar/title');
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        var documentData = this.getCancellationRecord().getDocumentData();

        return [
            {
                xtype: 'checkbox',
                name: 'createDocument',
                cls: 'viison-common--checkbox-with-boxlabel',
                margin: '0 0 25 0',
                boxLabel: this.getViisonSnippet('document_sidebar/field/create_correction_of_invoice/label'),
                inputValue: true,
                checked: documentData.get('createDocument'),
                value: documentData.get('createDocument'),
                fieldStyle: {
                    'margin-top': '8px',
                },
                listeners: {
                    scope: this,
                    change: function (checkbox, newValue) {
                        this.updateFormState(newValue);
                    },
                },
            }, {
                xtype: 'label',
                cls: 'is--viison-common--label',
                text: this.getViisonSnippet('document_sidebar/field/invoice_number/label') + ':',
                margin: '0 0 6 2',
            }, {
                xtype: 'textfield',
                name: 'invoiceNumber',
                itemId: 'invoiceNumber',
                margin: '0 0 12 0',
                helpText: this.getViisonSnippet('document_sidebar/field/invoice_number/help_text'),
                value: documentData.get('invoiceNumber'),
                disabled: !documentData.get('createDocument'),
            }, {
                xtype: 'label',
                cls: 'is--viison-common--label',
                text: this.getViisonSnippet('document_sidebar/field/document_date/label') + ':',
                margin: '0 0 6 2',
            }, {
                xtype: 'datefield',
                name: 'documentDate',
                itemId: 'documentDate',
                margin: '0 0 12 0',
                value: documentData.get('documentDate'),
                disabled: !documentData.get('createDocument'),
            }, {
                xtype: 'label',
                cls: 'is--viison-common--label',
                text: this.getViisonSnippet('document_sidebar/field/document_comment/label') + ':',
                margin: '0 0 6 2',
            }, {
                xtype: 'textarea',
                name: 'documentComment',
                itemId: 'documentComment',
                cls: 'is--viison-common--textarea',
                height: 150,
                value: documentData.get('documentComment'),
                disabled: !documentData.get('createDocument'),
            },
        ];
    },

    /**
     * Disables / enables all form fields based on a given boolean value.
     *
     * @param {boolean} createCorrectionOfInvoiceEnabled
     */
    updateFormState: function (createCorrectionOfInvoiceEnabled) {
        var newDisabledState = true;
        if (createCorrectionOfInvoiceEnabled) {
            newDisabledState = false;
        }

        this.down('#invoiceNumber').setDisabled(newDisabledState);
        this.down('#documentDate').setDisabled(newDisabledState);
        this.down('#documentComment').setDisabled(newDisabledState);
    },

});
