// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCancellation.view.editor.Footer', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_cancellation-editor-footer',
    cls: 'viison_pickware_erp_cancellation-editor-footer',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
        'Shopware.apps.ViisonPickwareERPCancellation.mixin.DataRetrieval',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_cancellation/main',

    layout: {
        type: 'hbox',
        align: 'stretch',
        pack: 'end',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();
        this.getCancellationRecord().on(
            'totalAmountChanged',
            function (totalAmount) {
                this.updateTotalAmount(totalAmount);
            },
            this
        );

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        var cancellationRecord = this.getCancellationRecord();

        return [
            {
                xtype: 'checkbox',
                name: 'cancelShippingCosts',
                boxLabel: this.renderShippingCostsLabel(),
                cls: 'viison-common--checkbox-with-boxlabel',
                margin: '5 0 0 0',
                inputValue: true,
                value: cancellationRecord.get('cancelShippingCosts'),
                checked: cancellationRecord.get('cancelShippingCosts'),
                disabled: !cancellationRecord.hasShippingCosts(),
                listeners: {
                    scope: this,
                    change: function (checkbox, value) {
                        this.fireEvent('shippingCostsCheckboxChanged', this, value);
                    },
                },
            },
            {
                xtype: 'container',
                itemId: 'totalAmountContainer',
                cls: 'is--total-amount-container',
                html: this.renderTotalAmount(cancellationRecord.get('totalAmount')),
            },
        ];
    },

    /**
     * @param {number} totalAmount
     */
    updateTotalAmount: function (totalAmount) {
        this.down('#totalAmountContainer').el.dom.innerHTML = this.renderTotalAmount(totalAmount);
    },

    /**
     * @returns {string}
     */
    renderShippingCostsLabel: function () {
        var shippingCostsValue = ViisonCurrencyFormatter.renderer(this.getCancellationRecord().get('shippingCosts'));

        return Ext.String.format(
            this.getViisonSnippet('footer/shipping_costs/label'),
            shippingCostsValue
        );
    },

    /**
     * @param {number} totalAmount
     * @returns {string}
     */
    renderTotalAmount: function (totalAmount) {
        var totalAmountValue = ViisonCurrencyFormatter.renderer(totalAmount);

        return this.getTotalAmountTemplate().apply({ totalAmountValue: totalAmountValue });
    },

    /**
     * @returns {Ext.XTemplate}
     */
    getTotalAmountTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<label>',
                    this.getViisonSnippet('footer/total_amount/label') + ':',
                '</label>',
                '<span class="is--total-amount">',
                    '{totalAmountValue}',
                '</span>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

});
