// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCancellation.view.editor.items.ItemListContainer', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_cancellation-editor-items-item_list_container',
    cls: 'viison_pickware_erp_cancellation-editor-items-item_list_container',

    mixins: [
        'Shopware.apps.ViisonPickwareERPCancellation.mixin.DataRetrieval',
    ],

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    /**
     * @type {number}
     */
    itemGroupId: null,

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            this.subApp.getView('editor.items.ItemListHeader').create({
                itemGroupId: this.itemGroupId,
                collapseExpandCallback: this.onCollapseExpandCallback.bind(this),
                disableEnableCallback: this.onDisableEnableCallback.bind(this),
                addPseudoItemCallback: this.onAddPseudoItemCallback.bind(this),
            }),
            this.subApp.getView('editor.items.ItemList').create({
                itemId: 'itemList',
                itemGroupId: this.itemGroupId,
            }),
        ];
    },

    onCollapseExpandCallback: function () {
        if (this.isCollapsed()) {
            this.expand();
        } else {
            this.collapse();
        }

        this.up('viison_pickware_erp_cancellation-editor').doLayout();
    },

    onDisableEnableCallback: function (enabled) {
        if (enabled) {
            this.enableItemList();
        } else {
            this.disableItemList();
        }

        this.fireEvent('disableEnableItemGroup', this, enabled, this.getItemGroupById(this.itemGroupId));
    },

    onAddPseudoItemCallback: function () {
        this.fireEvent('addPseudoItem', this, this.getItemGroupById(this.itemGroupId));
        this.down('#itemList').displayPseudoItemsInfoIfNecessary();
    },

    /**
     * @returns {boolean}
     */
    isCollapsed: function () {
        return this.collapsed;
    },

    expand: function () {
        this.down('#itemList').setVisible(true);
        this.removeCls('is--collapsed');

        this.collapsed = false;
    },

    collapse: function () {
        this.down('#itemList').setVisible(false);
        this.addCls('is--collapsed');

        this.collapsed = true;
    },

    enableItemList: function () {
        this.down('#itemList').setDisabled(false);
    },

    disableItemList: function () {
        this.down('#itemList').setDisabled(true);
    },

});
