// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCancellation.view.editor.items.ItemListHeader', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_cancellation-editor-items-item_list_header',
    cls: 'viison_pickware_erp_cancellation-editor-items-item_list_header',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
        'Shopware.apps.ViisonPickwareERPCancellation.mixin.DataRetrieval',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_cancellation/main',

    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    /**
     * @type {number}
     */
    itemGroupId: null,

    /**
     * Callback, which will be called after the collapse / expand state of the item group has been changed
     * by the user.
     *
     * @type {funtion}
     */
    collapseExpandCallback: Ext.emptyFn,

    /**
     * Callback, which will be called after the disabled / enabled state of the item group has been changed
     * by the user.
     *
     * @type {funtion}
     */
    disableEnableCallback: Ext.emptyFn,

    /**
     * Callback, which will be called if the user click the add pseudo item button, which will only be
     * displayed for items group of type 'PSEUDO'.
     *
     * @type {funtion}
     */
    addPseudoItemCallback: Ext.emptyFn,

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        var itemGroupRecord = this.getItemGroupById(this.itemGroupId);
        var items = [];

        if (this.getCancellationRecord().getItemGroups().count() > 1) {
            items.push({
                xtype: 'button',
                cls: 'is--button-collapse-item-list',
                scope: this,
                handler: function () {
                    this.collapseExpandCallback();
                },
            });
        }

        if (itemGroupRecord.isTypeReturnShipment()) {
            items.push({
                xtype: 'checkbox',
                itemId: 'disableItemList',
                inputValue: true,
                value: !itemGroupRecord.isDisabled(),
                checked: !itemGroupRecord.isDisabled(),
                listeners: {
                    scope: this,
                    change: function (checkbox, value) {
                        this.disableEnableCallback(value);
                    },
                },
            });
        }

        items.push({
            xtype: 'container',
            cls: 'is--item-list-header-text',
            html: this.renderHeaderText(itemGroupRecord),
        });

        if (itemGroupRecord.isTypePseudo()) {
            items.push({
                xtype: 'button',
                text: this.getViisonSnippet('item_list_header/button/add_pseudo_item/text'),
                cls: 'is--header-button has--icon-add primary',
                scope: this,
                handler: function () {
                    this.addPseudoItemCallback();
                },
            });
        }

        return items;
    },

    /**
     * @param {Shopware.apps.ViisonPickwareERPCancellation.model.ItemGroup} itemGroup
     * @returns {string}
     */
    renderHeaderText: function (itemGroup) {
        if (itemGroup.isTypeReturnShipment()) {
            return Ext.String.format(
                this.getViisonSnippet('item_list_header/header_text/return_shipment'),
                itemGroup.get('returnShipmentNumber')
            );
        }
        if (itemGroup.isTypePseudo()) {
            return this.getViisonSnippet('item_list_header/header_text/pseudo_items');
        }

        return this.getViisonSnippet('item_list_header/header_text/non_shipped_items');
    },

});
