// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPConfig.view.form.Document', {
    override: 'Shopware.apps.Config.view.form.Document',

    /**
     * @override
     */
    getFormItems: function () {
        var formItems = this.callParent(arguments);

        var pickListDocumentConfigItems = [{
            xtype: 'tinymce',
            fieldLabel: ViisonCommonApp.getSnippet('signature_value', 'backend/viison_pickware_erp_config/pick_list'),
            labelWidth: 100,
            name: 'Signature_Value',
            translatable: true,
        }, {
            xtype: 'textarea',
            fieldLabel: ViisonCommonApp.getSnippet('signature_style', 'backend/viison_pickware_erp_config/pick_list'),
            labelWidth: 100,
            name: 'Signature_Style',
            translatable: true,
        }, {
            xtype: 'tinymce',
            fieldLabel: ViisonCommonApp.getSnippet('info_value', 'backend/viison_pickware_erp_config/pick_list'),
            labelWidth: 100,
            name: 'Info_Value',
            hidden: true,
            translatable: true,
        }, {
            xtype: 'textarea',
            fieldLabel: ViisonCommonApp.getSnippet('info_style', 'backend/viison_pickware_erp_config/pick_list'),
            labelWidth: 100,
            name: 'Info_Style',
            translatable: true,
        }];

        Ext.Array.each(formItems, function (item) {
            if (item.name && item.name === 'elementFieldSet') {
                Ext.Array.push(item.items, pickListDocumentConfigItems);
            }
        });

        return formItems;
    },
});
