// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCustomerArticles.controller.Main', {

    extend: 'Ext.app.Controller',

    /**
     * @Override
     */
    init: function () {
        this.control({
            'viison_pickware_erp_customer_articles-detail-article_list': {
                searchFieldChanged: this.onSearchFieldChanged,
                showArticle: this.onShowArticle,
                showOrder: this.onShowOrder,
            },
        });

        this.callParent(arguments);
    },

    /**
     * Adds the given search query to the panel's store's extra params and reloads it.
     *
     * @param Shopware.apps.ViisonPickwareERPCustomerArticles.view.detail.ArticleList panel
     * @param String query
     */
    onSearchFieldChanged: function (panel, query) {
        panel.store.getProxy().extraParams.query = query;
        panel.store.loadPage(1);
    },

    /**
     * Opens a new Article subapp showing the article associated with the given record.
     *
     * @param Shopware.apps.ViisonPickwareERPCustomerArticles.model.Article record
     */
    onShowArticle: function (record) {
        Shopware.app.Application.addSubApplication({
            name: 'Shopware.apps.Article',
            params: {
                articleId: record.get('articleId'),
            },
        });
    },

    /**
     * Opens a new Order subapp showing the order associated with the given record.
     *
     * @param Shopware.apps.ViisonPickwareERPCustomerArticles.model.Article record
     */
    onShowOrder: function (record) {
        Shopware.app.Application.addSubApplication({
            name: 'Shopware.apps.Order',
            action: 'detail',
            params: {
                orderId: record.get('orderId'),
            },
        });
    },

});
