// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCustomerArticles.model.Article', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'orderId', type: 'int' },
        { name: 'orderNumber', type: 'string' },
        { name: 'orderTime', type: 'date' },
        { name: 'articleId', type: 'int' },
        { name: 'articleNumber', type: 'string' },
        { name: 'articleName', type: 'string' },
        { name: 'quantity', type: 'int' },
        { name: 'canceledQuantity', type: 'int' },
        { name: 'price', type: 'float' },
        {
            name: 'total',
            type: 'float',
            convert: function (value, record) {
                return Ext.isNumeric(record.get('price')) ? (record.get('price') * record.get('quantity')) : record.get('price');
            },
        },
        { name: 'taxRate', type: 'float' },
    ],

});
