// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCustomerArticles.store.Article', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPCustomerArticles.model.Article',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    sorters: [{
        property: 'order_.orderTime',
        direction: 'DESC',
    }],
    proxy: {
        type: 'ajax',
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPCustomerArticles/getArticleList'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
