// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCustomerArticles.view.detail.ArticleList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_customer_articles-detail-article_list',
    cls: 'viison-common--grid has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_customer_articles/main',

    style: {
        borderLeft: 'none !important',
        borderRight: 'none !important',
        borderBottom: 'none !important',
    },
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.columns = this.createColumns();
        this.dockedItems = [{
            xtype: 'toolbar',
            dock: 'top',
            ui: 'shopware-ui',
            cls: ' is--viison-common--toolbar',
            items: this.createTopToolbarItems(),
        }, {
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        }];

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        return [{
            dataIndex: 'orderNumber',
            header: this.getViisonSnippet('model/article/order_number'),
            flex: 1,
        }, {
            xtype: 'datecolumn',
            dataIndex: 'orderTime',
            header: this.getViisonSnippet('model/article/order_time'),
            format: 'd.m.Y H:i:s',
            flex: 2,
        }, {
            dataIndex: 'articleNumber',
            header: this.getViisonSnippet('model/article/article_number'),
            flex: 2,
        }, {
            dataIndex: 'articleName',
            header: this.getViisonSnippet('model/article/article_name'),
            flex: 3,
        }, {
            dataIndex: 'quantity',
            header: this.getViisonSnippet('model/article/quantity'),
            align: 'right',
            flex: 1,
        }, {
            dataIndex: 'canceledQuantity',
            header: this.getViisonSnippet('model/article/canceled_quantity'),
            align: 'right',
            flex: 1,
        }, {
            dataIndex: 'price',
            header: this.getViisonSnippet('model/article/price'),
            renderer: ViisonCurrencyFormatter.renderer,
            align: 'right',
            flex: 1,
        }, {
            dataIndex: 'total',
            header: this.getViisonSnippet('model/article/total'),
            renderer: ViisonCurrencyFormatter.renderer,
            align: 'right',
            flex: 1,
        }, {
            xtype: 'numbercolumn',
            dataIndex: 'taxRate',
            header: this.getViisonSnippet('model/article/tax_rate'),
            align: 'right',
            format: '00%/i',
            flex: 1,
        }, {
            xtype: 'actioncolumn',
            width: 60,
            align: 'center',
            items: [{
                iconCls: 'sprite-pencil',
                tooltip: this.getViisonSnippet('action_column/show_article/tooltip'),
                scope: this,
                getClass: function (value, meta, record) {
                    // Hide icon, if no articleId is set
                    if (!record.get('articleId')) {
                        return 'x-hide-visibility';
                    }

                    return undefined;
                },
                handler: function (grid, rowIndex) {
                    this.fireEvent('showArticle', grid.getStore().getAt(rowIndex));
                },
            }, {
                iconCls: 'sprite-inbox',
                tooltip: this.getViisonSnippet('action_column/show_order/tooltip'),
                scope: this,
                handler: function (grid, rowIndex) {
                    this.fireEvent('showOrder', grid.getStore().getAt(rowIndex));
                },
            }],
        }];
    },

    /**
     * @return Ext.toolbar.Item[]
     */
    createTopToolbarItems: function () {
        return [
            '->',
            {
                xtype: 'textfield',
                name: 'search',
                cls: 'searchfield',
                emptyText: this.getViisonSnippet('toolbar/search_field/placeholder'),
                width: 200,
                enableKeyEvents: true,
                listeners: {
                    buffer: 500,
                    scope: this,
                    change: function (field) {
                        this.fireEvent('searchFieldChanged', this, field.value);
                    },
                },
            },
        ];
    },

});
