// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPCustomerArticles.view.detail.Window', {

    override: 'Shopware.apps.Customer.view.detail.Window',

    /**
     * @Override
     */
    getTabs: function () {
        var tabs = this.callParent(arguments);

        // Create main controller
        this.subApplication.addController({
            name: 'Shopware.apps.ViisonPickwareERPCustomerArticles.controller.Main',
        });

        // Create and load a new articles store
        var articlesStore = Ext.create('Shopware.apps.ViisonPickwareERPCustomerArticles.store.Article');
        articlesStore.filters.add('customerId', Ext.create('Ext.util.Filter', {
            property: 'order_.customerId',
            value: this.record.get('id'),
        }));
        articlesStore.load();

        // Create and add the custom articles tab
        this.viisonPickwareERPCustomerArticlesTab = Ext.create('Shopware.apps.ViisonPickwareERPCustomerArticles.view.detail.ArticleList', {
            title: ViisonCommonApp.getSnippet(
                'tab/title',
                'backend/viison_pickware_erp_customer_articles/main'
            ),
            store: articlesStore,
        });
        tabs.push(this.viisonPickwareERPCustomerArticlesTab);

        return tabs;
    },

});
