// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPIndexNewsWidget.model.News', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'title', type: 'string' },
        { name: 'link', type: 'string' },
        { name: 'linkHash', type: 'string' },
        { name: 'date', type: 'date' },
        {
            name: 'visited',
            type: 'boolean',
            convert: function (value, record) {
                var visited = window.localStorage.getItem('viison_pickware_erp_index_news_widget-news_cache');
                if (!visited) {
                    return false;
                }
                var visitedLinks = Ext.decode(visited) || {};

                return !!visitedLinks[record.get('linkHash')];
            },
        },
    ],

});
