// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPIndexNewsWidget.view.Main', {

    extend: 'Shopware.apps.Index.view.widgets.Base',
    alias: 'widget.viison-pickware-erp-news-widget',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_index_news_widget/main',

    layout: 'fit',
    bodyPadding: '8 8',

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('panel/title');
        this.newsStore = Ext.create('Shopware.apps.ViisonPickwareERPIndexNewsWidget.store.News');
        this.items = [
            this.createNewsGrid(),
        ];
        this.tools = [{
            type: 'refresh',
            scope: this,
            handler: function () {
                this.newsStore.load();
            },
        }];

        this.callParent(arguments);
    },

    /**
     * Creates the main Widget grid and its columns
     *
     * @return Ext.grid.Panel
     */
    createNewsGrid: function () {
        return Ext.create('Ext.grid.Panel', {
            border: 0,
            store: this.newsStore,
            columns: [{
                dataIndex: 'title',
                header: this.getViisonSnippet('panel/columns/title'),
                flex: 1,
            }, {
                dataIndex: 'date',
                header: this.getViisonSnippet('panel/columns/date'),
                width: 80,
                align: 'right',
                renderer: Ext.util.Format.dateRenderer(),
            }],
            listeners: {
                scope: this,
                itemclick: function (view, record) {
                    // Open clicked news in new tab/window
                    window.open(record.data.link, '_blank');

                    // Update grid
                    view.getSelectionModel().deselectAll();
                    this.setVisited(record.data.linkHash);
                    record.set('visited', true);
                    view.refresh();
                },
            },
            viewConfig: {
                getRowClass: function (record) {
                    // Return css class to modify style (highlight unvisited links)
                    return record.get('visited') ? 'x-widget-viison-pickware-erp-index-news-widget-visited' : 'x-widget-viison-pickware-erp-index-news-widget-unvisited';
                },
            },
        });
    },

    /**
     * Remembers visited links in a local storage (saved linkHash)
     *
     * @param string linkHash
     */
    setVisited: function (linkHash) {
        var visited = window.localStorage.getItem('viison_pickware_erp_index_news_widget-news_cache');
        var visitedLinks = Ext.decode(visited) || {};
        if (visitedLinks[linkHash]) {
            return;
        }

        // Mark link as visited
        visitedLinks[linkHash] = true;
        window.localStorage.setItem('viison_pickware_erp_index_news_widget-news_cache', Ext.encode(visitedLinks));
    },

});
