// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPIndexPluginTestCheck.view.Menu', {

    override: 'Shopware.apps.Index.view.Menu',

    /**
     * @Override
     */
    initComponent: function () {
        // Trigger the test license range check 500 ms after the menu was created
        this.on('menu-created', function () {
            window.setTimeout(function () {
                this.performPluginTestCheck();
            }.bind(this), 500);
        }, this);

        this.callParent(arguments);
    },

    /**
     * Checks for a test license and its validity or a test version in combination with a Shopware PR license.
     */
    performPluginTestCheck: function () {
        Ext.Ajax.request({
            url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPIndexPluginTestCheck/checkLicense'),
            success: function (response) {
                // Decode the response
                var responseData = Ext.JSON.decode(response.responseText, true);
                if (!responseData || !responseData.pluginTestStatus || responseData.pluginTestStatus.daysLeft > 14) {
                    return;
                }

                // Show growl notification
                var expiredSnippet = ViisonCommonApp.getSnippet(
                    'notification/message/test_expired',
                    'backend/viison_pickware_erp_index_plugin_test_check/main'
                );
                var expiresSoonSnippet = ViisonCommonApp.getSnippet(
                    'notification/message/test_expires_soon',
                    'backend/viison_pickware_erp_index_plugin_test_check/main'
                );
                var message = (responseData.pluginTestStatus.daysLeft < 0) ? expiredSnippet : expiresSoonSnippet;

                Shopware.Notification.createStickyGrowlMessage({
                    title: ViisonCommonApp.getSnippet(
                        'notification/title',
                        'backend/viison_pickware_erp_index_plugin_test_check/main'
                    ),
                    text: Ext.String.format(message, Math.abs(responseData.pluginTestStatus.daysLeft)),
                    btnDetail: {
                        text: ViisonCommonApp.getSnippet(
                            'notification/buttons/more_info',
                            'backend/viison_pickware_erp_index_plugin_test_check/main'
                        ),
                        link: 'https://www.pickware.de/starten/mit-pickware-direkt-starten',
                    },
                });
            },
        });
    },

});
