// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPIndexPurchasePriceModeCheck.view.Menu', {

    override: 'Shopware.apps.Index.view.Menu',

    /**
     * @Override
     */
    initComponent: function () {
        // Trigger the purchase price mode check 500 ms after the menu was created
        this.on('menu-created', function () {
            window.setTimeout(function () {
                ViisonPickwarePurchasePriceConverter.checkPurchasePriceModeConfiguration();
            }, 500);
        }, this);

        this.callParent(arguments);
    },

});
