// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPIndexStockCheck.view.Menu', {

    override: 'Shopware.apps.Index.view.Menu',

    /**
     * @Override
     */
    initComponent: function () {
        // Trigger the stock range check 500 ms after the menu was created
        this.on('menu-created', function () {
            window.setTimeout(function () {
                this.performStockCheck();
            }.bind(this), 500);
        }, this);

        this.callParent(arguments);
    },

    /**
     * Checks all articles for already initialised stocks.
     */
    performStockCheck: function () {
        Ext.Ajax.request({
            url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPIndexStockCheck/checkStock'),
            success: function (response) {
                // Decode the response
                var responseData = Ext.JSON.decode(response.responseText, true);
                if (!responseData || parseInt(responseData.count, 10) === 0) {
                    return;
                }

                Shopware.Notification.createStickyGrowlMessage({
                    title: ViisonCommonApp.getSnippet(
                        'notification/title',
                        'backend/viison_pickware_erp_index_stock_check/main'
                    ),
                    text: Ext.String.format(
                        ViisonCommonApp.getSnippet(
                            'notification/message',
                            'backend/viison_pickware_erp_index_stock_check/main'
                        ),
                        responseData.count
                    ),
                    btnDetail: {
                        text: ViisonCommonApp.getSnippet(
                            'notification/open_button',
                            'backend/viison_pickware_erp_index_stock_check/main'
                        ),
                        callback: function () {
                            // Open the stock setup sub app
                            Shopware.app.Application.addSubApplication({
                                name: 'Shopware.apps.ViisonPickwareERPStockInitialization',
                                localizedName: ViisonCommonApp.getSnippet(
                                    'notification/title',
                                    'backend/viison_pickware_erp_index_stock_check/main'
                                ),
                            });
                        },
                    },
                });
            },
        });
    },

});
