// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPMessageBoxWithCheckboxes.view.MessageBoxWithCheckboxes', {
    extend: 'Ext.window.MessageBox',

    /**
     * @Override
     */
    constructor: function () {
        this.callParent(arguments);

        // Locale files only translate the button text of the message box
        // singelton Ext.Msg (= Ext.MessageBox), but not of the parent class
        // Ext.window.MessageBox. Hence we need to apply the translation
        // manually.
        this.buttonText = Ext.Msg.buttonText;
    },

    initComponent: function () {
        this.callParent(arguments);

        // Apply shopware styling
        this.msg.allowHtml = true;
        this.bottomTb.addCls('shopware-toolbar');
        this.bottomTb.setUI('shopware-ui');
        Ext.each(this.msgButtons, function (button) {
            var cls = (button.itemId === 'ok' || button.itemId === 'yes') ? 'primary' : 'secondary';
            button.addCls(cls);
        });

        this.checkboxesContainer = Ext.create('Ext.container.Container', {
            flex: 1,
            layout: {
                type: 'anchor',
            },
            style: {
                'margin-top': '12px',
            },
            items: [],
        });
        this.promptContainer.add(this.checkboxesContainer);

        this.bottomMessage = Ext.create('Ext.form.field.Display', {
            id: this.id + '-displayfield-bottom',
            cls: this.baseCls + '-text',
        });
        this.promptContainer.add(this.bottomMessage);
    },

    reconfigure: function () {
        this.callParent(arguments);

        if (this.cfg.checkboxes) {
            this.checkboxesContainer.show();
            this.checkboxesContainer.removeAll();
            this.checkboxesContainer.add(this.cfg.checkboxes);
        } else {
            this.checkboxesContainer.hide();
        }

        if (this.cfg.bottomMessage) {
            this.bottomMessage.setValue(this.cfg.bottomMessage);
            this.bottomMessage.show();
        } else {
            this.bottomMessage.hide();
        }
    },
}, function () {
    ViisonMessageBoxWithCheckboxes = new this();
});
