// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrder.controller.List', {

    override: 'Shopware.apps.Order.controller.List',

    /* eslint-disable no-unused-vars */
    /**
     * @override
     *
     * Ensures that all serverside changes made to an order after altering it using the row
     * editing feature of the order list are synced back to the client by reloading the order list.
     *
     * @param {Ext.grid.plugin.RowEditing} editor
     * @param {object} event
     * @param {Ext.data.Store} store
     */
    onSaveOrder: function (editor, event, store) {
        var orderRecord = store.getAt(event.rowIdx);
        if (orderRecord == null) {
            return;
        }

        var originalOrderSaveMethod = orderRecord.save;
        orderRecord.save = function (saveOptions) {
            var originalCallback = saveOptions.callback;
            saveOptions.callback = function (data, operation) {
                originalCallback.call(this, data, operation);
                store.load();
            };

            originalOrderSaveMethod.call(this, saveOptions);
        };

        this.callParent(arguments);

        orderRecord.save = originalOrderSaveMethod;
    },
    /* eslint-enable no-unused-vars */
});
