// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderBatchLabelCreation.controller.ListDispatch', {

    override: 'Shopware.apps.ViisonShippingCommonOrder.controller.ListDispatch',

    viisonSkipBatchLabelCreationBasedPositionUpdateAlert: false,

    /**
     * Checks whether the order status of the label creation is 'canceled' (4) or 'completely shipped' (7) and, if it
     * is, asks the user whether the orders' items shall be 'cancelled' or 'shipped', too. Finally the parent method is
     * called, either directly without asking the user or after the user closed the alert.
     *
     * Method overwrites of the actual order update after the label creation handle the actual position update.
     */
    onConfirmBatchLabelCreation: function () {
        var newState = this.batchStatusWindow.statusSelectionBox.getValue();
        if (this.viisonSkipBatchLabelCreationBasedPositionUpdateAlert || (newState !== 4 && newState !== 7)) {
            this.callParent();
            this.viisonSkipBatchLabelCreationBasedPositionUpdateAlert = false;

            return;
        }

        // Ask user for position update
        var namespace = 'backend/viison_pickware_erp_order_batch_label_creation/main';
        var title = ViisonCommonApp.getSnippet('alert/title', namespace);
        var message;
        if (newState === 4) {
            var cancelShippingCostsCheckbox = Ext.create('Ext.form.field.Checkbox', {
                boxLabel: ViisonCommonApp.getSnippet('alert/batch/checkbox/cancel_shipping_costs', namespace),
                checked: true,
                style: {
                    'margin-left': '20px',
                },
            });
            var createCancellationInvoiceCheckbox = Ext.create('Ext.form.field.Checkbox', {
                boxLabel: ViisonCommonApp.getSnippet('alert/batch/checkbox/create_cancellation_invoice', namespace),
                checked: true,
                style: {
                    'margin-left': '20px',
                },
            });
            // Use the message prompt with checkboxes from the ViisonPickwareERPOrderStatusBasedPositionUpdate sub app
            Ext.create('Shopware.apps.ViisonPickwareERPMessageBoxWithCheckboxes.view.MessageBoxWithCheckboxes').show({
                title: title,
                icon: Ext.Msg.QUESTION,
                msg: ViisonCommonApp.getSnippet('alert/batch/message/cancelled', namespace),
                checkboxes: [
                    cancelShippingCostsCheckbox,
                    createCancellationInvoiceCheckbox,
                ],
                buttons: Ext.Msg.YESNOCANCEL,
                scope: this,
                callback: function (buttonId) {
                    if (buttonId === 'cancel') {
                        return;
                    }
                    if (buttonId === 'yes') {
                        ViisonPickwareERPOrderEventBus.on(
                            'collectBatchStoreParams',
                            function (store) {
                                store.getProxy().extraParams.pickwareCancelUnshippedItemsOfOrder = 1;
                                if (cancelShippingCostsCheckbox.checked) {
                                    store.getProxy().extraParams.pickwareCancelShippingCosts = 1;
                                }
                                if (createCancellationInvoiceCheckbox.checked) {
                                    store.getProxy().extraParams.pickwareCreateCancellationInvoice = 1;
                                }
                            },
                            this,
                            {
                                single: true,
                            }
                        );
                    }

                    // Save the orders by calling the onProcessChanges method again, but this time skipping the alert
                    this.viisonSkipBatchLabelCreationBasedPositionUpdateAlert = true;
                    this.onConfirmBatchLabelCreation();
                },
            });
        } else if (newState === 7) {
            message = ViisonCommonApp.getSnippet('alert/batch/message/completely_shipped', namespace);
            ViisonPickwareBinLocationSelectionAlert.selectWarehouse(
                title,
                message,
                Ext.Msg.YESNOCANCEL,
                function (buttonId, warehouse) {
                    if (buttonId === 'cancel') {
                        return;
                    }
                    if (buttonId === 'yes') {
                        ViisonPickwareERPOrderEventBus.on(
                            'collectBatchStoreParams',
                            function (store) {
                                store.getProxy().extraParams.stockChangeWarehouseId = warehouse.get('id');
                                store.getProxy().extraParams.pickwareMarkOrdersAsShipped = 1;
                            },
                            this,
                            {
                                single: true,
                            }
                        );
                    }

                    // Save the orders by calling the onProcessChanges method again, but this time skipping the alert
                    this.viisonSkipBatchLabelCreationBasedPositionUpdateAlert = true;
                    this.onConfirmBatchLabelCreation();
                },
                this
            );
        }
    },
});
