// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderCancellation.controller.Main', {

    extend: 'Ext.app.Controller',

    /**
     * @override
     */
    init: function () {
        this.callParent(arguments);

        this.control({
            'order-position-panel': {
                cancelPositions: this.onCancelPositions,
            },
        });
    },

    /**
     * @param {Shopware.apps.Order.model.Order} orderRecord
     * @param {Ext.panel.Panel} positionsPanel
     */
    onCancelPositions: function (orderRecord, positionsPanel) {
        var selectionModel = positionsPanel.orderPositionGrid.getSelectionModel();
        var selectedPositions = selectionModel.getSelection();

        Shopware.app.Application.addSubApplication({
            name: 'Shopware.apps.ViisonPickwareERPCancellation',
            orderId: orderRecord.get('id'),
            autoPreselectAllReturnShipments: false,
            preselectedOrderDetailIds: selectedPositions.map(function (position) {
                return position.get('id');
            }),
            afterCancellationCallback: function () {
                this.getController('Detail').viisonPickwareERPUpdateDetailWindow(
                    orderRecord,
                    positionsPanel.up('window')
                );
            }.bind(this),
        });
    },

});
