// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderCancellation.view.detail.Position', {

    override: 'Shopware.apps.Order.view.detail.Position',

    /**
     * @override
     */
    createGridToolbar: function () {
        var toolbar = this.callParent(arguments);

        // Add a button for canceling the selection order positions
        toolbar.add(this.createCancelPositionsButton());

        return toolbar;
    },

    /**
     * @returns {Ext.button.Button}
     */
    createCancelPositionsButton: function () {
        this.cancelPositionsButton = Ext.create('Ext.button.Button', {
            iconCls: 'sprite-blue-document--minus',
            text: ViisonCommonApp.getSnippet(
                'detail/position/toolbar/button/cancel_positions',
                'backend/viison_pickware_erp_order_cancellation/main'
            ),
            action: 'cancelPositions',
            scope: this,
            handler: function () {
                this.fireEvent('cancelPositions', this.record, this);
            },
        });

        return this.cancelPositionsButton;
    },

    /**
     * @override
     */
    getColumns: function () {
        return ViisonPickwareERPQuantityColumnInjector.injectColumn(this.callParent(arguments), {
            dataIndex: 'pickwareCanceledQuantity',
            header: ViisonCommonApp.getSnippet(
                'column/viison_canceled_quantity/header',
                'backend/viison_pickware_erp_order_cancellation/main'
            ),
            sortable: true,
            width: 60,
        });
    },
});
