// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderCommon.controller.Main', {

    extend: 'Ext.app.Controller',

    /**
     * @override
     */
    init: function () {
        this.control({
            'order-detail-window tabpanel': {
                render: this.onRenderTabPanelFocus,
            },
        });

        this.callParent(arguments);
    },

    /**
     * Checks the sub app parameters for a 'focus' and, if it is set selects the tab that matches it.
     *
     * @param {Ext.tab.Panel} orderDetailWindowTabPanel Panel containing all the tabs of the order detail window
     */
    onRenderTabPanelFocus: function (orderDetailWindowTabPanel) {
        var subApp = this.subApplication;
        if (subApp.params && subApp.params.focus) {
            var tab = orderDetailWindowTabPanel.down(subApp.params.focus);
            if (tab) {
                orderDetailWindowTabPanel.setActiveTab(tab);
            }
        }
    },

});
