// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderDeletionWarning.controller.List', {

    override: 'Shopware.apps.Order.controller.List',

    /**
     * @Override
     *
     * Overrides Shopware's order deletion handler, in order to add
     * a custom info message to the shown confirm dialog, in case that
     * the order has at least one order position, which has a "remaining"
     * shipped amount greater than zero.
     */
    onDeleteOrder: function (order) {
        // Determine whether or not the order has at least one order position
        // with a shipped value greater than zero.
        var hasPositionWithShippedNotZero = false;
        order.getPositions().getRange().forEach(function (position) {
            if (position.get('shipped') > 0) {
                hasPositionWithShippedNotZero = true;
            }
        });

        if (!hasPositionWithShippedNotZero) {
            // Nothing to do, if all order positions are already "restocked"
            // where necessary
            this.callParent(arguments);

            return;
        }

        // Backup an manipulate confirm method in order to be able to append
        // a custom message to the default confirm message, shown by Shopware
        // before an order is deleted.
        var messsageBoxConfirmBackup = Ext.MessageBox.confirm;
        Ext.MessageBox.confirm = function (config, message, callback, scope) {
            var deleteOrderInfo = ViisonCommonApp.getSnippet(
                'delete_order/message',
                'backend/viison_pickware_erp_order_deletion_warning/main'
            );
            message += '<br><br><strong style="font-weight:bold;">' + deleteOrderInfo + '</strong>';

            return messsageBoxConfirmBackup.apply(Ext.MessageBox, [config, message, callback, scope]);
        };

        // Call parent to display the confirm dialog and to process the
        // deletion if necessary
        this.callParent(arguments);

        // Restore initial confirm method
        Ext.MessageBox.confirm = messsageBoxConfirmBackup;
    },

});
