// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderDerivedQuantityColumns.view.detail.Position', {
    override: 'Shopware.apps.Order.view.detail.Position',

    /**
     * @override
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        columns = ViisonPickwareERPQuantityColumnInjector.injectColumn(columns, {
            dataIndex: 'pickwareOrderedQuantity', // Fake data index for sorting with ViisonPickwareERPQuantityColumnInjector
            header: ViisonCommonApp.getSnippet(
                'column/pickware_ordered_quantity/header',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            tooltip: ViisonCommonApp.getSnippet(
                'column/pickware_ordered_quantity/tooltip',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            sortable: false,
            width: 60,
            hidden: true,
            renderer: function (value, meta, record) {
                return record.get('quantity') + record.get('pickwareCanceledQuantity');
            },
        });

        columns = ViisonPickwareERPQuantityColumnInjector.injectColumn(columns, {
            dataIndex: 'pickwareLeftForShippingQuantity', // Fake data index for sorting with ViisonPickwareERPQuantityColumnInjector
            header: ViisonCommonApp.getSnippet(
                'column/pickware_left_for_shipping_quantity/header',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            tooltip: ViisonCommonApp.getSnippet(
                'column/pickware_left_for_shipping_quantity/tooltip',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            sortable: false,
            width: 120,
            hidden: true,
            renderer: function (value, meta, record) {
                return (record.get('quantity') + record.get('pickwareCanceledReturnedQuantity')) - record.get('shipped');
            },
        });

        columns = ViisonPickwareERPQuantityColumnInjector.injectColumn(columns, {
            dataIndex: 'pickwareCanceledUnshippedQuantity', // Fake data index for sorting with ViisonPickwareERPQuantityColumnInjector
            header: ViisonCommonApp.getSnippet(
                'column/pickware_cancelled_unshipped_quantity/header',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            tooltip: ViisonCommonApp.getSnippet(
                'column/pickware_cancelled_unshipped_quantity/tooltip',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            sortable: false,
            width: 140,
            hidden: true,
            renderer: function (value, meta, record) {
                return record.get('pickwareCanceledQuantity') - record.get('pickwareCanceledReturnedQuantity');
            },
        });

        columns = ViisonPickwareERPQuantityColumnInjector.injectColumn(columns, {
            dataIndex: 'pickwareCanceledReturnedQuantity',
            header: ViisonCommonApp.getSnippet(
                'column/pickware_cancelled_returned_quantity/header',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            tooltip: ViisonCommonApp.getSnippet(
                'column/pickware_cancelled_returned_quantity/tooltip',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            sortable: false,
            width: 140,
            hidden: true,
        });

        columns = ViisonPickwareERPQuantityColumnInjector.injectColumn(columns, {
            dataIndex: 'pickwareAtCustomerQuantity', // Fake data index for sorting with ViisonPickwareERPQuantityColumnInjector
            header: ViisonCommonApp.getSnippet(
                'column/pickware_at_customer_quantity/header',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            tooltip: ViisonCommonApp.getSnippet(
                'column/pickware_at_customer_quantity/tooltip',
                'backend/viison_pickware_erp_order_derived_quantity_columns/main'
            ),
            sortable: false,
            width: 120,
            hidden: true,
            renderer: function (value, meta, record) {
                return record.get('shipped') - record.get('pickwareReturnedQuantity');
            },
        });

        return columns;
    },
});
