// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderDetailQuantityColumnInjector', {

    singleton: true,
    alternateClassName: 'ViisonPickwareERPQuantityColumnInjector',

    columnOrder: [
        'quantity',
        'pickwareCanceledQuantity',
        'pickwareOrderedQuantity',
        'pickwareCanceledUnshippedQuantity',
        'shipped',
        'pickwareLeftForShippingQuantity',
        'pickwareReturnedQuantity',
        'pickwareCanceledReturnedQuantity',
        'pickwareAtCustomerQuantity',
    ],

    /**
     * Puts the given column somewhere right to the column 'quantity' and takes care of the correct positioning of
     * all columns places there.
     *
     * @param {object[]} orderDetailColumns
     * @param {object} column
     * @return {object[]}
     */
    injectColumn: function (orderDetailColumns, column) {
        // Find all columns that should be places left to the column to insert.
        var leftColumns = this.columnOrder.slice(0, this.columnOrder.indexOf(column.dataIndex));

        // Of those leftColumns find the one placed farthest to the right
        var leftColumnIndex = -1;
        for (var i = 0; i < orderDetailColumns.length; i += 1) {
            if (leftColumns.indexOf(orderDetailColumns[i].dataIndex) !== -1) {
                leftColumnIndex = i;
            }
        }

        // Insert the column there
        orderDetailColumns.splice(leftColumnIndex + 1, 0, column);

        return orderDetailColumns;
    },
});
