// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderDocumentCreation.controller.Batch', {
    override: 'Shopware.apps.Order.controller.Batch',
    viisonPickwareERPOrderDocumentCreationSkipPickListAlert: false,

    /**
     * @override
     */
    onProcessChanges: function (formComponent, options) {
        if (this.viisonPickwareERPOrderDocumentCreationSkipPickListAlert) {
            this.callParent(arguments);
            this.viisonPickwareERPOrderDocumentCreationSkipPickListAlert = false;

            return;
        }

        var pickListDocumentId = ViisonCommonApp.getConfig('viisonPickListDocumentId', 'ViisonPickwareERPOrderDocumentCreation');
        if (!pickListDocumentId) {
            // Signal the backend user if the pick list document template could not be found (e.g. template was renamed)
            Shopware.Notification.createGrowlMessage(
                ViisonCommonApp.getSnippet('pickListNotFound/growl/title', 'backend/viison_pickware_erp_order_document_creation/pick_list'),
                ViisonCommonApp.getSnippet('pickListNotFound/growl/message', 'backend/viison_pickware_erp_order_document_creation/pick_list'),
                'ViisonPickwareERPOrderDocumentCreation'
            );
        }
        var formValues = formComponent.getValues();
        if (!formValues.documentType || formValues.documentType !== pickListDocumentId) {
            // Call parent if no pick list document is created
            this.callParent(arguments);

            return;
        }

        // Pick lists are going to be created. Prompt warehouse dialog and pass selected warehouse to the store
        ViisonPickwareBinLocationSelectionAlert.selectWarehouse(
            ViisonCommonApp.getSnippet('warehouseSelection/title', 'backend/viison_pickware_erp_order_document_creation/pick_list'),
            ViisonCommonApp.getSnippet('warehouseSelection/message', 'backend/viison_pickware_erp_order_document_creation/pick_list'),
            Ext.Msg.OKCANCEL,
            function (buttonId, warehouse) {
                if (buttonId !== 'ok') {
                    return;
                }

                ViisonPickwareERPOrderEventBus.on('collectBatchStoreParams', function (store) {
                    store.getProxy().extraParams.pickListWarehouseId = warehouse.get('id');
                }, this, {
                    single: true,
                });

                // Recall this function and skip this controller so the updated information will be processed
                this.viisonPickwareERPOrderDocumentCreationSkipPickListAlert = true;
                this.onProcessChanges(formComponent, options);
            },
            this
        );
    },
});
