// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderDocumentDeletion.view.list.Document', {

    override: 'Shopware.apps.Order.view.list.Document',

    /**
     * @Override
     */
    getColumns: function () {
        var columns = this.callParent();

        // Try to find an action column
        var actionColumn = null;
        Ext.each(columns, function (column) {
            if (column.xtype === 'actioncolumn') {
                actionColumn = column;
                actionColumn.width += 30;

                return false;
            }

            return undefined;
        });
        if (!actionColumn) {
            // Action column does not exist yet, hence create one
            actionColumn = {
                xtype: 'actioncolumn',
                width: 30,
                items: [],
            };
            columns.push(actionColumn);
        }

        // Add a 'delete' action
        actionColumn.items.push({
            iconCls: 'sprite-minus-circle-frame',
            tooltip: ViisonCommonApp.getSnippet(
                'column/action/delete/tooltip',
                'backend/viison_pickware_erp_order_document_deletion/main'
            ),
            scope: this,
            getClass: function (html, metadata, record) {
                // Fire event to ask for permission to show the document delete button. The action
                // button will be hidden if a registered event handler returns false. This event
                // is used by the ViisonDATEV plugin to prevent the deletion of some documents.
                if (!this.fireEvent('ViisonPickwareERP.showDocumentDeleteButton', record)) {
                    return 'x-hidden';
                }

                return undefined;
            },
            handler: function (grid, rowIndex) {
                this.fireEvent('deleteDocument', this, grid.getStore().getAt(rowIndex));
            },
        });

        return columns;
    },

});
